/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.GCanvasListener;
import acm.graphics.GCompound;
import acm.graphics.GContainer;
import acm.graphics.GMath;
import acm.graphics.GMouseEvent;
import acm.graphics.GObject;
import acm.graphics.GPoint;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;

public class GCanvas
extends Container
implements GContainer {
    private GCanvasListener gCanvasListener;
    private GObject lastObject;
    private GObject dragObject;
    private ArrayList contents = new ArrayList();
    private ArrayList enabledList = new ArrayList();
    private Image offscreenImage;
    private boolean autoRepaint;
    private boolean nativeArcFlag;
    private boolean opaque;

    public GCanvas() {
        this.setBackground(Color.white);
        this.setOpaque(true);
        this.setAutoRepaintFlag(true);
        this.setLayout(null);
        this.gCanvasListener = new GCanvasListener(this);
        this.addFocusListener(this.gCanvasListener);
        this.addComponentListener(this.gCanvasListener);
        this.addMouseListener(this.gCanvasListener);
        this.addMouseMotionListener(this.gCanvasListener);
    }

    public void add(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            if (gObject.getParent() != null) {
                gObject.getParent().remove(gObject);
            }
            gObject.setParent(this);
            this.contents.add(gObject);
            if (gObject.areMouseListenersEnabled()) {
                this.enabledList.add(gObject);
            }
        }
        this.conditionalRepaint();
    }

    public final void add(GObject gObject, double d, double d2) {
        this.add(gObject);
        gObject.setLocation(d, d2);
    }

    public final void add(GObject gObject, GPoint gPoint) {
        this.add(gObject, gPoint.getX(), gPoint.getY());
    }

    public void remove(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            ((AbstractCollection)this.contents).remove(gObject);
            ((AbstractCollection)this.enabledList).remove(gObject);
            gObject.setParent(null);
        }
        this.conditionalRepaint();
    }

    public void removeAll() {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            this.contents.clear();
            this.enabledList.clear();
        }
        super.removeAll();
        this.repaint();
    }

    public Component add(Component component) {
        super.add(component);
        Dimension dimension = component.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            Dimension dimension2 = component.getPreferredSize();
            if (dimension.width == 0) {
                dimension.width = dimension2.width;
            }
            if (dimension.height == 0) {
                dimension.height = dimension2.height;
            }
            component.setSize(dimension);
        }
        return component;
    }

    public final void add(Component component, double d, double d2) {
        component.setLocation(GMath.round(d), GMath.round(d2));
        this.add(component);
    }

    public final void add(Component component, GPoint gPoint) {
        this.add(component, gPoint.getX(), gPoint.getY());
    }

    public void remove(Component component) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            super.remove(component);
        }
        this.conditionalRepaint();
    }

    public int getElementCount() {
        return this.contents.size();
    }

    public GObject getElement(int n) {
        return (GObject)this.contents.get(n);
    }

    public GObject getElementAt(double d, double d2) {
        return this.getElementAt(this.contents, d, d2);
    }

    public final GObject getElementAt(GPoint gPoint) {
        return this.getElementAt(gPoint.getX(), gPoint.getY());
    }

    public Iterator iterator() {
        return this.iterator(0);
    }

    public Iterator iterator(int n) {
        return GCompound.createIterator(this, n);
    }

    public void setOpaque(boolean bl) {
        this.opaque = bl;
        this.conditionalRepaint();
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public int getWidth() {
        return this.getSize().width;
    }

    public int getHeight() {
        return this.getSize().height;
    }

    public void paint(Graphics graphics) {
        Cloneable cloneable;
        Graphics graphics2 = graphics;
        if (this.isOpaque()) {
            if (this.offscreenImage == null) {
                this.initOffscreenImage();
            }
            if (this.offscreenImage != null) {
                graphics = this.offscreenImage.getGraphics();
            }
            cloneable = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, ((Dimension)cloneable).width, ((Dimension)cloneable).height);
            graphics.setColor(this.getForeground());
        }
        cloneable = this.contents;
        synchronized (cloneable) {
            int n = this.contents.size();
            int n2 = 0;
            while (n2 < n) {
                ((GObject)this.contents.get(n2)).paintObject(graphics);
                ++n2;
            }
        }
        if (this.isOpaque() && this.offscreenImage != null) {
            graphics2.drawImage(this.offscreenImage, 0, 0, this);
        }
        super.paint(graphics2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void setAutoRepaintFlag(boolean bl) {
        this.autoRepaint = bl;
    }

    public boolean getAutoRepaintFlag() {
        return this.autoRepaint;
    }

    public void setNativeArcFlag(boolean bl) {
        this.nativeArcFlag = bl;
    }

    public boolean getNativeArcFlag() {
        return this.nativeArcFlag;
    }

    protected void sendToFront(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.indexOf(gObject);
            if (n >= 0) {
                this.contents.remove(n);
                this.contents.add(gObject);
                this.updateEnabledList();
            }
        }
        this.conditionalRepaint();
    }

    protected void sendToBack(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.indexOf(gObject);
            if (n >= 0) {
                this.contents.remove(n);
                this.contents.add(0, gObject);
                this.updateEnabledList();
            }
        }
        this.conditionalRepaint();
    }

    protected void sendForward(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.indexOf(gObject);
            if (n >= 0) {
                this.contents.remove(n);
                this.contents.add(Math.min(this.contents.size(), n + 1), gObject);
                this.updateEnabledList();
            }
        }
        this.conditionalRepaint();
    }

    protected void sendBackward(GObject gObject) {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            int n = this.contents.indexOf(gObject);
            if (n >= 0) {
                this.contents.remove(n);
                this.contents.add(Math.max(0, n - 1), gObject);
                this.updateEnabledList();
            }
        }
        this.conditionalRepaint();
    }

    protected void dispatchMouseEvent(MouseEvent mouseEvent) {
        int n;
        GObject gObject = this.getElementAt(this.enabledList, mouseEvent.getX(), mouseEvent.getY());
        GMouseEvent gMouseEvent = null;
        if (gObject != this.lastObject) {
            if (this.lastObject != null) {
                gMouseEvent = new GMouseEvent(this.lastObject, 505, mouseEvent);
                this.lastObject.fireMouseListeners(gMouseEvent);
            }
            if (gObject != null) {
                gMouseEvent = new GMouseEvent(gObject, 504, mouseEvent);
                gObject.fireMouseListeners(gMouseEvent);
            }
        }
        this.lastObject = gObject;
        if (this.dragObject != null) {
            gObject = this.dragObject;
        }
        if (gObject != null && (n = mouseEvent.getID()) != 505 && n != 504 && (n != 506 || this.dragObject != null)) {
            if (n == 501) {
                this.dragObject = gObject;
            } else if (n == 502) {
                this.dragObject = null;
            }
            gMouseEvent = new GMouseEvent(gObject, n, mouseEvent);
            gObject.fireMouseListeners(gMouseEvent);
        }
        if (gMouseEvent != null && gMouseEvent.isConsumed()) {
            mouseEvent.consume();
        }
    }

    protected void initOffscreenImage() {
        ArrayList arrayList = this.contents;
        synchronized (arrayList) {
            Dimension dimension;
            block6: {
                block5: {
                    dimension = this.getSize();
                    if (dimension.width <= 0) break block5;
                    if (dimension.height > 0) break block6;
                }
                Object var2_3 = null;
                return;
            }
            this.offscreenImage = this.createImage(dimension.width, dimension.height);
        }
    }

    protected void conditionalRepaint() {
        if (this.autoRepaint) {
            this.repaint();
        }
    }

    protected void updateEnabledList() {
        if (this.enabledList.size() > 0) {
            this.enabledList.clear();
            int n = this.contents.size();
            int n2 = 0;
            while (n2 < n) {
                GObject gObject = (GObject)this.contents.get(n2);
                if (gObject.areMouseListenersEnabled()) {
                    this.enabledList.add(gObject);
                }
                ++n2;
            }
        }
    }

    private GObject getElementAt(ArrayList arrayList, double d, double d2) {
        ArrayList arrayList2 = this.contents;
        synchronized (arrayList2) {
            int n = arrayList.size() - 1;
            while (n >= 0) {
                GObject gObject = (GObject)arrayList.get(n);
                if (gObject.contains(d, d2)) {
                    GObject gObject2 = gObject;
                    Object var8_8 = null;
                    return gObject2;
                }
                --n;
            }
        }
        return null;
    }
}

